import { Router } from "express";
import { storagePut } from "./storage";

const router = Router();

// Helper to convert base64 to buffer
function base64ToBuffer(base64: string): Buffer {
  const base64Data = base64.replace(/^data:image\/\w+;base64,/, "").replace(/^data:application\/pdf;base64,/, "");
  return Buffer.from(base64Data, "base64");
}

// Upload ID card image
router.post("/upload-id-card", async (req, res) => {
  try {
    const { file, requestId } = req.body;
    
    if (!file || !requestId) {
      return res.status(400).json({ error: "Missing required fields" });
    }

    const buffer = base64ToBuffer(file);
    const fileKey = `id-cards/${requestId}-${Date.now()}.jpg`;
    
    const result = await storagePut(fileKey, buffer, "image/jpeg");
    
    res.json({ url: result.url });
  } catch (error) {
    console.error("Error uploading ID card:", error);
    res.status(500).json({ error: "Failed to upload file" });
  }
});

// Upload payment proof
router.post("/upload-payment-proof", async (req, res) => {
  try {
    const { file, requestId } = req.body;
    
    if (!file || !requestId) {
      return res.status(400).json({ error: "Missing required fields" });
    }

    const buffer = base64ToBuffer(file);
    const fileKey = `payment-proofs/${requestId}-${Date.now()}.jpg`;
    
    const result = await storagePut(fileKey, buffer, "image/jpeg");
    
    res.json({ url: result.url });
  } catch (error) {
    console.error("Error uploading payment proof:", error);
    res.status(500).json({ error: "Failed to upload file" });
  }
});

// Upload report PDF
router.post("/upload-report", async (req, res) => {
  try {
    const { file, requestId } = req.body;
    
    if (!file || !requestId) {
      return res.status(400).json({ error: "Missing required fields" });
    }

    const buffer = base64ToBuffer(file);
    const fileKey = `reports/${requestId}-${Date.now()}.pdf`;
    
    const result = await storagePut(fileKey, buffer, "application/pdf");
    
    res.json({ url: result.url });
  } catch (error) {
    console.error("Error uploading report:", error);
    res.status(500).json({ error: "Failed to upload file" });
  }
});

export default router;
